% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/addConservationScores.R
\name{addConservationScores}
\alias{addConservationScores}
\alias{addConservationScores,GuideSet-method}
\alias{addConservationScores,PairedGuideSet-method}
\alias{addConservationScores,NULL-method}
\title{Add on-target composite score to a \linkS4class{GuideSet} object.}
\usage{
addConservationScores(object, ...)

\S4method{addConservationScores}{GuideSet}(
  object,
  conservationFile,
  nucExtension = 9,
  fun = c("mean", "max"),
  scoreName = "score_conservation"
)

\S4method{addConservationScores}{PairedGuideSet}(
  object,
  conservationFile,
  nucExtension = 9,
  fun = c("mean", "max"),
  scoreName = "score_conservation"
)

\S4method{addConservationScores}{NULL}(object)
}
\arguments{
\item{object}{A \linkS4class{GuideSet} object or a 
\linkS4class{PairedGuideSet} object.}

\item{...}{Additional arguments, currently ignored.}

\item{conservationFile}{String specifing the BigWig file containing
conservation scores.}

\item{nucExtension}{Number of nucleotides to include on each side of the 
cut site to calculate the conservation score. 9 by default. 
The region will have (2*nucExtension + 1) nucleotides in total.}

\item{fun}{String specifying the function to use to calculate the final
 conservation score in the targeted region. Must be either "mean"
(default) or "max".}

\item{scoreName}{String specifying the name of the conservation score to
be used as a columm name. Users can choose whatever they like. 
Default is "score_conservation".}
}
\value{
\code{guideSet} with column specified by \code{scoreName} 
    appended in \code{mcols(guideSet)}.
}
\description{
Add on-target composite score to a \linkS4class{GuideSet}
    object.
}
\details{
The function creates a conservation score for each gRNA
    by using the max, or average, conservation score in the genomic 
    region where the cut occurs. A BigWig file storing conservation 
    stores must be provided. Such files can be downloaded from the
    UCSC genome browser. See vignette for more information.
}
\author{
Jean-Philippe Fortin
}
