% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/Nuclease-class.R
\docType{class}
\name{motifs}
\alias{motifs}
\alias{motifLength}
\alias{nucleaseName}
\alias{targetType}
\alias{weights}
\alias{nucleaseName<-}
\alias{targetType<-}
\alias{weights<-}
\alias{cutSites}
\alias{isCutting}
\alias{isRnase}
\alias{isDnase}
\alias{Nuclease-class}
\alias{Nuclease}
\alias{show,Nuclease-method}
\alias{nucleaseName,Nuclease-method}
\alias{nucleaseName<-,Nuclease-method}
\alias{targetType,Nuclease-method}
\alias{targetType<-,Nuclease-method}
\alias{weights,Nuclease-method}
\alias{weights<-,Nuclease-method}
\alias{isCutting,Nuclease-method}
\alias{isRnase,Nuclease-method}
\alias{isDnase,Nuclease-method}
\alias{motifs,Nuclease-method}
\alias{motifLength,Nuclease-method}
\alias{cutSites,Nuclease-method}
\title{An S4 class to represent a nuclease.}
\usage{
motifs(object, ...)

motifLength(object, ...)

nucleaseName(object)

targetType(object)

weights(object, ...)

nucleaseName(object) <- value

targetType(object) <- value

weights(object) <- value

cutSites(object, ...)

isCutting(object)

isRnase(object)

isDnase(object)

Nuclease(
  nucleaseName,
  targetType = c("DNA", "RNA"),
  motifs = NULL,
  cutSites = NULL,
  weights = rep(1, length(motifs)),
  metadata = list()
)

\S4method{show}{Nuclease}(object)

\S4method{nucleaseName}{Nuclease}(object)

\S4method{nucleaseName}{Nuclease}(object) <- value

\S4method{targetType}{Nuclease}(object)

\S4method{targetType}{Nuclease}(object) <- value

\S4method{weights}{Nuclease}(object, expand = FALSE)

\S4method{weights}{Nuclease}(object) <- value

\S4method{isCutting}{Nuclease}(object)

\S4method{isRnase}{Nuclease}(object)

\S4method{isDnase}{Nuclease}(object)

\S4method{motifs}{Nuclease}(
  object,
  primary = FALSE,
  strand = c("+", "-"),
  expand = FALSE,
  as.character = FALSE
)

\S4method{motifLength}{Nuclease}(object)

\S4method{cutSites}{Nuclease}(object, strand = c("+", "-", "both"), combine = TRUE, middle = FALSE)
}
\arguments{
\item{object}{\linkS4class{Nuclease} object.}

\item{...}{Additional arguments for class-specific methods}

\item{value}{New value to pass to the setter functions.}

\item{nucleaseName}{Name of the nuclease.}

\item{targetType}{String specifying target type ("DNA" or "RNA").}

\item{motifs}{Character vector of recognition sequence motifs
written from 5' to 3' written in Rebase convention.
If the point of cleavage has been determined, the
precise site is marked with ^. Only letters in the
IUPAC code are accepted. For nucleases that cleave
away from their recognition sequence, the cleavage
sites are indicated in parentheses. See details for
more information.}

\item{cutSites}{Matrix with 2 rows (+ and - strand, respectively)
specifying the cleavage coordinates relative to the first
nucleotide of the motif sequence. Each column corresponds
to a motif specified in the \code{motifs} slot.}

\item{weights}{Optional numeric vector specifying relative weights
for the recognition motifs to specify cleavage probabilities.}

\item{metadata}{Optional list providing global metadata information.}

\item{expand}{Should sequences be expanded to only contain ATCG nucleotides?
FALSE by default.}

\item{primary}{Should only the motif with the highest weight be returned?
FALSE by default. Only relevant if weights are stored in the 
\linkS4class{Nuclease} object.}

\item{strand}{Strand to allow reverse complementation of the motif.
"+" by default.}

\item{as.character}{Should the motif sequences be returned as a 
character vector? FALSE by default.}

\item{combine}{Should only unique values be considered?
TRUE by default.}

\item{middle}{For staggered cuts, should the middle point between
the cut on the forward strand and the cut on the reverse strand
be considered as the cut site? FALSE by default.}
}
\value{
A Nuclease object
}
\description{
Return motif string representations of recognition sites.

Return length of the recognition sites sequences.
}
\section{Functions}{
\itemize{
\item \code{Nuclease()}: Create a \linkS4class{Nuclease} object

}}
\section{Slots}{

\describe{
\item{\code{nucleaseName}}{Name of the nuclease.}

\item{\code{targetType}}{Character string indicationg target type ("DNA" or "RNA").}

\item{\code{motifs}}{DNAStringSet of recognition sequence motifs
written from 5' to 3'.}

\item{\code{cutSites}}{Matrix with 2 rows (+ and - strand, respectively)
specifying the cleavage coordinates relative to the first
nucleotide of the motif sequence. Each column corresponds
to a motif specified in the \code{motifs} slot.}

\item{\code{weights}}{Optional numeric vector specifying relative weights
for the motifs corresponding to cleavage probabilities.}

\item{\code{metadata}}{Optional string providing a description of the nuclease.}
}}

\section{Constructors}{

    Use the constructor \code{link{Nuclease}} to create a Nuclease object.
}

\section{Accessors}{

\describe{
    \item{\code{nucleaseName}:}{To get the name of the nuclease.} 
    \item{\code{targetType}:}{To get the target type ("DNA" or "RNA").}
    \item{\code{metadata}:}{To get the metadata list of the nuclease.} 
    \item{\code{motifs}:}{To get the recognition mofif
         nucleotide sequences.}
    \item{\code{weights}:}{To get nuclease weights.} 
    \item{\code{cutSites}:}{To get nuclease cut sites.} 
}
}

\examples{
EcoRI <- Nuclease("EcoRI",
                  motifs=c("G^AATTC"),
                  metadata=list(description="EcoRI restriction enzyme"))

}
\seealso{
See the \linkS4class{CrisprNuclease} for CRISPR-specific nucleases.
}
