% Generated by roxygen2 (4.0.1): do not edit by hand
\name{glossi}
\alias{glossi}
\title{Calculate a Chi-squared Statistic and P-Value for
Independent Items of a Set Using the GLOSSI Method}
\usage{
glossi(pvals, snp.gsc)
}
\arguments{
\item{pvals}{A numerical vector of p-values with names
corresponding to elements listed in the \code{geneIds} slot in
the snp.gsc object.}

\item{snp.gsc}{An object of class \code{GeneSetCollection}
where geneIds holds the items of each set corresponding to the
pvals.}
}
\value{
An object with the corresponding GLOSSI results. If
snp.gsc is a \code{GeneSetCollection} (i.e., multiple sets of
interest), then the corresponding \code{GLOSSIResultCollection}
is returned. If snp.gsc is a \code{GeneSet}, a \code{GLOSSIResult}
object will be returned.
}
\description{
Calculates the p-value representing the association of the
set with the phenotype of interest, assuming all items in the
set are independent, using the GLOSSI method.
}
\details{
This function calculates a p-value for sets of SNPs that
reside within a gene set collection. We calculate the chi-
square p-values and statistic by applying Fisher's
transformation to the observed p-values.
}
\author{
Jason Hackney, Jessica Larson, Caitlin McHugh
\email{mchughc@uw.edu}
}
\references{
Chai, High-Seng and Sicotte, Hughes et al.
GLOSSI: a method to assess the association of genetic loci-sets
with complex diseases.
BMC Bioinformatics, 2009.
}
\examples{
    set.seed(30)
    pvals <- runif(100)
    names(pvals) <- paste0("rs", 1:100)
    snpGS5 <- GeneSet(geneIds=names(pvals)[1:5], setName="set5")
    res <- glossi (pvals, snpGS5)
}

