% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general-functions.R
\name{transformRNAseq}
\alias{transformRNAseq}
\title{Transform RNA-seq data using common transformations}
\usage{
transformRNAseq(
  y,
  normFactors = "TMM",
  transformation = "arcsin",
  geneLength = NA,
  meanFilterCutoff = NULL,
  verbose = TRUE
)
}
\arguments{
\item{y}{(\emph{n} x \emph{q}) \code{matrix} or \code{data.frame} of observed counts
for \emph{n} observations and \emph{q} variables}

\item{normFactors}{The type of estimator to be used to normalize for differences in
library size: \dQuote{\code{TC}} for total count, \dQuote{\code{DESeq}} for
the normalization method in the DESeq package, and \dQuote{\code{TMM}} for
the TMM normalization method (Robinson and Oshlack, 2010). Can also be a
vector (of length \emph{q}) containing pre-estimated library size estimates
for each sample.}

\item{transformation}{Transformation type to be used: \dQuote{\code{arcsin}},
\dQuote{\code{logit}}, \dQuote{\code{logMedianRef}}, \dQuote{\code{profile}},
\dQuote{\code{voom}}, \dQuote{\code{logRPKM}} (if \code{geneLength} is provided by user),
\dQuote{\code{logclr}}, \dQuote{\code{clr}}, \dQuote{\code{alr}}, \dQuote{\code{ilr}},
\dQuote{\code{none}},}

\item{geneLength}{Vector of length equal to the number of rows in \dQuote{\code{y}} providing
the gene length (bp) for RPKM calculation}

\item{meanFilterCutoff}{Value used to filter low mean normalized counts}

\item{verbose}{If \code{TRUE}, include verbose output}
}
\value{
\item{tcounts }{Transformed counts}
\item{normCounts }{Normalized counts}
\item{snorm }{Per-sample normalization factors divided by mean normalization factor}
\item{ellnorm }{Per-sample normalization factors}
}
\description{
Application of common transformations for RNA-seq data prior to fitting a normal mixture model
}
\examples{
set.seed(12345)
countmat <- matrix(runif(300*4, min=0, max=500), nrow=300, ncol=4)
countmat <- countmat[which(rowSums(countmat) > 0),]
conds <- rep(c("A","B","C","D"), each=2)

## Arcsin transformation, TMM normalization
arcsin <- transformRNAseq(countmat, normFactors="TMM", transformation="arcsin")$tcounts
## Logit transformation, TMM normalization
logit <- transformRNAseq(countmat, normFactors="TMM", transformation="logit")$tcounts
## logCLR transformation, TMM normalization
logclr <- transformRNAseq(countmat, normFactors="TMM", transformation="logclr")$tcounts

}
