% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-AllClasses.R
\docType{class}
\name{coseqResults-class}
\alias{coseqResults-class}
\alias{coseqResults}
\title{coseqResults object and constructor}
\usage{
coseqResults(
  SummarizedExperiment,
  allResults,
  model = NULL,
  transformation = NULL,
  tcounts = NULL,
  y_profiles = NULL,
  normFactors = NULL
)
}
\arguments{
\item{SummarizedExperiment}{a \code{RangedSummarizedExperiment} of \code{coseq} results}

\item{allResults}{List of conditional probabilities of cluster membership for each gene,
in all models fit}

\item{model}{\code{"Normal"} or \code{"Poisson"}, the mixture model used for co-expression}

\item{transformation}{Transformation applied to counts to obtain \code{tcounts}}

\item{tcounts}{Transformed counts used for mixture model fitting}

\item{y_profiles}{y profiles used for \code{coseq} plotting}

\item{normFactors}{Scaling factors used for normalization}
}
\value{
a coseqResults object
}
\description{
\code{coseqResults} is a subclass of \code{RangedSummarizedExperiment},
used to store the co-expression results as well as some additional
information useful for plotting (\code{tcounts}, \code{y_profiles}) and
meta-information about the co-expression analysis (\code{transformation},
\code{normFactors}).
}
\details{
This constructor function would not typically be used by "end users".
This simple class extends the \code{RangedSummarizedExperiment} class of the
SummarizedExperiment package
to allow other packages to write methods for results
objects from the coseq package. It is used by \code{\link{coseqRun}}
to wrap up the results table.
}
