% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coseq-package.R
\docType{package}
\name{coseq-package}
\alias{coseq-package}
\title{Co-expression and co-abundance analysis of high-throughput sequencing data}
\description{
Co-expression analysis for expression profiles arising from high-throughput sequencing
data. Feature (e.g., gene) profiles are clustered using adapted transformations and
mixture models or a K-means algorithm, and model selection criteria
(to choose an appropriate number of clusters) are provided.
}
\details{
\tabular{ll}{ Package: \tab coseq\cr Type: \tab Package\cr Version:
\tab 1.15.4\cr Date: \tab 2020-12-03 \cr License: \tab GPL-3\cr LazyLoad:
\tab yes\cr }
}
\examples{
## Simulate toy data, n = 300 observations
set.seed(12345)
countmat <- matrix(runif(300*4, min=0, max=500), nrow=300, ncol=4)
countmat <- countmat[which(rowSums(countmat) > 0),]
conds <- rep(c("A","B","C","D"), each=2)

## Run the Normal mixture model for K = 2,3,4
run_arcsin <- coseq(object=countmat, K=2:4, iter=5, transformation="arcsin",
                    model="Normal", seed=12345)
run_arcsin

## Plot and summarize results
plot(run_arcsin)
summary(run_arcsin)

## Compare ARI values for all models (no plot generated here)
ARI <- compareARI(run_arcsin, plot=FALSE)

## Compare ICL values for models with arcsin and logit transformations
run_logit <- coseq(object=countmat, K=2:4, iter=5, transformation="logit",
                   model="Normal")
compareICL(list(run_arcsin, run_logit))

## Use accessor functions to explore results
clusters(run_arcsin)
likelihood(run_arcsin)
nbCluster(run_arcsin)
ICL(run_arcsin)

## Examine transformed counts and profiles used for graphing
tcounts(run_arcsin)
profiles(run_arcsin)

## Run the K-means algorithm for logclr profiles for K = 2,..., 20
run_kmeans <- coseq(object=countmat, K=2:20, transformation="logclr",
                    model="kmeans")
run_kmeans
}
\references{
Godichon-Baggioni, A., Maugis-Rabusseau, C. and Rau, A. (2018) Clustering
transformed compositional data using K-means, with applications in gene
expression and bicycle sharing system data. Journal of Applied Statistics,
doi:10.1080/02664763.2018.1454894.

Rau, A. and Maugis-Rabusseau, C. (2018) Transformation and model choice for
co-expression analayis of RNA-seq data. Briefings in Bioinformatics, 19(3)-425-436.

Rau, A., Maugis-Rabusseau, C., Martin-Magniette, M.-L., Celeux,
G. (2015) Co-expression analysis of high-throughput transcriptome sequencing
data with Poisson mixture models. Bioinformatics, doi:
10.1093/bioinformatics/btu845.

Rau, A., Celeux, G., Martin-Magniette, M.-L., Maugis-Rabusseau, C. (2011)
Clustering high-throughput sequencing data with Poisson mixture models.
Inria Research Report 7786. Available at
\url{http://hal.inria.fr/inria-00638082}.
}
\author{
Andrea Rau, Cathy Maugis-Rabusseau, Antoine Godichon-Baggioni

Maintainer: Andrea Rau <\url{andrea.rau@inrae.fr}>
}
\keyword{cluster}
\keyword{models}
