% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corral.R
\name{var_stabilize}
\alias{var_stabilize}
\title{Apply a variance stabilizing transformation}
\usage{
var_stabilize(inp, transform = c("sqrt", "freemantukey", "anscombe"))
}
\arguments{
\item{inp}{matrix, numeric, counts or logcounts; can be sparse Matrix or matrix}

\item{transform}{character indicating which method should be applied. Defaults to the square root transform (`"sqrt"`). Other options include `"freemantukey"` and `"anscombe"`.}
}
\value{
variance-stabilized matrix; sparse if possible
}
\description{
Prior to running CA, there is an option to apply a variance stabilizing transformation. This function can be called explicitly or used with the `vst_mth` argument in \code{corral} and \code{corral_preproc}.
}
\examples{
x <- as.matrix(rpois(100, lambda = 50), ncol = 10)
vst_x <- var_stabilize(x)
}
