% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output.R
\docType{methods}
\name{CNV.detailplot_wrap}
\alias{CNV.detailplot_wrap}
\alias{CNV.detailplot_wrap,CNV.analysis-method}
\title{CNV.detailplot_wrap}
\usage{
CNV.detailplot_wrap(object, ...)

\S4method{CNV.detailplot_wrap}{CNV.analysis}(object, set_par = TRUE,
  main = NULL, ...)
}
\arguments{
\item{object}{\code{CNV.analysis} object.}

\item{...}{Additional paramters supplied to \code{CNV.detailplot}.}

\item{set_par}{logical. Use recommended graphical parameters for \code{oma} and \code{mar}? Defaults to \code{TRUE}. Original parameters are restored afterwards.}

\item{main}{character. Title of the plot. Defaults to sample name.}
}
\value{
\code{NULL}.
}
\description{
Create CNV plot for all detail regions.
}
\details{
This method is a wrapper of the \code{CNV.detailplot} method to plot all detail regions.
}
\examples{
# prepare
library(minfiData)
data(MsetEx)
d <- CNV.load(MsetEx)
data(detail_regions)
anno <- CNV.create_anno(detail_regions = detail_regions)

# create/modify object
x <- CNV.segment(CNV.detail(CNV.bin(CNV.fit(query = d['GroupB_1'],
    ref = d[c('GroupA_1', 'GroupA_2', 'GroupA_3')], anno))))

# output plots
CNV.genomeplot(x)
CNV.genomeplot(x, chr = 'chr6')
CNV.detailplot(x, name = 'PTEN')
CNV.detailplot_wrap(x)

# output text files
CNV.write(x, what = 'segments')
CNV.write(x, what = 'detail')
CNV.write(x, what = 'bins')
CNV.write(x, what = 'probes')
}
\author{
Volker Hovestadt \email{conumee@hovestadt.bio}
}
