% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findConsensusPeakRegionsIntern.R
\encoding{UTF-8}
\name{findConsensusPeakRegionsForOneChrom}
\alias{findConsensusPeakRegionsForOneChrom}
\title{Extract regions sharing features in more than one experiment for
one specific chromosome.}
\usage{
findConsensusPeakRegionsForOneChrom(
  chrName,
  allPeaks,
  allNarrowPeaks,
  extendingSize,
  expandToFitPeakRegion,
  shrinkToFitPeakRegion,
  minNbrExp,
  chrList
)
}
\arguments{
\item{chrName}{a \code{character}, the name of the chromosome to analyze.}

\item{allPeaks}{a \code{GRanges} containing all peaks from all experiments
sorted by position.}

\item{allNarrowPeaks}{a \code{GRanges} containing all narrow peaks from all
experiments sorted by position.}

\item{extendingSize}{a \code{numeric} value indicating the size of padding
at each side of the peaks median position to create the consensus
region. The minimum size of the consensu region will be equal to
twice the value of the \code{extendingSize} parameter. The size of
the \code{extendingSize} must be a positive integer. Default = 250.}

\item{expandToFitPeakRegion}{a \code{logical} indicating if the region set by
the \code{extendingSize} parameter is extended to include all narrow peak
regions. Only the narrow peaks regions of the peaks included in the
unextended region are used during the extension process. It is possible
that has a side effect, adding peaks are being included in the
extended region.}

\item{shrinkToFitPeakRegion}{a \code{logical} indicating if the region set
by the \code{extendingSize} parameter is shrinked to fit the narrow
peak regions.}

\item{minNbrExp}{a \code{numeric} indicating the minimum number of BED files
in which a peak must be present for a region to be retained. The
numeric must be a positive value inferior or equal to the number
of files present in the \code{narrowPeakFiles} parameter. Default = 1.}

\item{chrList}{a \code{Seqinfo} containing the name and the length of the
chromosomes to analyze.}
}
\value{
an object of \code{class} "commonFeatures".
}
\description{
Find regions sharing the same features for a minimum number of
experiments using called peaks of signal enrichment based on
pooled, normalized data (mainly coming from narrowPeak files). Tje
analysis is limited to one chromosome.
The peaks and narrow peaks are used to identify
the consensus regions. The minimum number of experiments that must
have at least on peak in a region so that it is retained as a
consensus region is specified by user, as well as the size of
mining regions.
}
\author{
Astrid Deschênes
}
\keyword{internal}
