% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.subtypes.R
\name{get.subtypes}
\alias{get.subtypes}
\title{Get ovarian cancer subtypes}
\usage{
get.subtypes(
  expression.dataset,
  entrez.ids = NULL,
  method = c("consensusOV", "Helland", "Verhaak", "Konecny", "Bentink"),
  ...
)
}
\arguments{
\item{expression.dataset}{Either a matrix of gene expression values with rows
 as genes, columns as samples;
or a BioBase::ExpressionSet object from MetaGxOvarian.
If \code{expression.dataset} is a matrix, then \code{entrez.ids} must have
length equal to the number of rows of \code{expression.dataset}.}

\item{entrez.ids}{A vector of Entrez Gene IDs, corresponding to the rows of
\code{expression.dataset}}

\item{method}{The subtyping method to use}

\item{...}{Optional parameters to be passed to the low level function}
}
\value{
A list with first value \code{Konecny.subtypes} containing a factor
of subtype names; and second value \code{spearman.cc.vals} containing the
Spearman correlation values per subtype
}
\description{
Get ovarian cancer subtypes
}
\examples{
library(Biobase)
data(GSE14764.eset)
expression.matrix <- exprs(GSE14764.eset)
entrez.ids <- as.character(fData(GSE14764.eset)$EntrezGene.ID)
get.subtypes(expression.matrix, entrez.ids, method="Konecny")

}
