% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consICA.R
\name{oneICA}
\alias{oneICA}
\title{Runs \code{\link[fastICA]{fastICA}}}
\usage{
oneICA(
  X,
  ncomp = 10,
  filter.thr = NULL,
  reduced = FALSE,
  fun = "logcosh",
  alg.typ = "deflation",
  assay_string = NULL
)
}
\arguments{
\item{X}{input data with features in rows and samples in columns. 
Could be a `SummarizedExperiment` object, matrix or `Seurat` object. 
For `SummarizedExperiment` with multiple assays or `Seurat` pass the name 
with `assay_string` parameter, otherwise the first will be taken.
See \code{\link[SummarizedExperiment]{SummarizedExperiment-class}}}

\item{ncomp}{number of components. Default value is 10}

\item{filter.thr}{filter rows in input matrix with max value > `filter.thr`.
Default value is NULL}

\item{reduced}{If TRUE returns reduced result (no X, see 'return')}

\item{fun}{the functional form of the G function used in the approximation 
to neg-entropy in fastICA. Default value is "logcosh"}

\item{alg.typ}{parameter for fastICA(). if alg.typ == "deflation" the 
components are extracted one 
at a time. if alg.typ == "parallel" the components are extracted 
simultaneously. Default value is "deflation"}

\item{assay_string}{name of assay for `SummarizedExperiment` or `Seurat` 
input object `X`. Default value is NULL}
}
\value{
a list with
        \item{X}{input `SummarizedExperiment` object}
        \item{nsamples, nfeatures}{dimension of X assay}
        \item{S, M}{consensus metagene and weight matrix}
        \item{ncomp}{number of components}
}
\description{
Runs \code{\link[fastICA]{fastICA}} once and store in a 
consICA manner
}
\examples{
data("samples_data")
res <- oneICA(samples_data)
}
\seealso{
\code{\link[fastICA]{fastICA}}
}
\author{
Petr V. Nazarov
}
