% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateSyntheticData.R
\name{simulateData}
\alias{simulateData}
\title{Simulate the Data}
\usage{
simulateData(
  n.vars,
  S1,
  prob.S1,
  sum.S1,
  truedispersions.S1,
  nfact_length.S1,
  S2,
  prob.S2,
  sum.S2,
  truedispersions.S2,
  nfact_length.S2,
  seq.depths,
  overdispersed
)
}
\arguments{
\item{n.vars}{The initial number of genes in the simulated data set. Based on the filtering conditions (\code{filter.threshold.total} and \code{filter.threshold.mediancpm}), the number of genes in the final data set may be lower than this number.}

\item{S1}{Indices in condition 1.}

\item{prob.S1}{Vector of means for condition 1.}

\item{sum.S1}{Sum of means for condition 1.}

\item{truedispersions.S1}{Vector of dispersions for condition 1.}

\item{nfact_length.S1}{Matrix of length factors for condition 1.}

\item{S2}{Indices in condition 2.}

\item{prob.S2}{Vector of means for condition 2.}

\item{sum.S2}{Sum of means for condition 2.}

\item{truedispersions.S2}{Vector of dispersions for condition 2.}

\item{nfact_length.S2}{Matrix of length factors for condition 2.}

\item{overdispersed}{Indices that are overdispersed.}
}
\value{
Z a n.var times 2*samples.per.cond matrix with the simulated data.
}
\description{
Use the Poisson or Negative Binomial model to simulate the data.
}
\keyword{internal}
