% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combi.R
\name{combi}
\alias{combi}
\title{Perform model-based data integration}
\usage{
combi(
  data,
  M = 2L,
  covariates = NULL,
  distributions,
  compositional,
  maxIt = 300L,
  tol = 0.001,
  verbose = FALSE,
  prevCutOff = 0.95,
  minFraction = 0.1,
  logTransformGaussian = TRUE,
  confounders = NULL,
  compositionalConf = rep(FALSE, length(data)),
  nleq.control = list(maxit = 1000L, cndtol = 1e-16),
  record = TRUE,
  weights = NULL,
  fTol = 1e-05,
  meanVarFit = "spline",
  maxFeats = 2000,
  dispFreq = 10L,
  allowMissingness = FALSE,
  biasReduction = TRUE,
  maxItFeat = 20L,
  initPower = 1
)
}
\arguments{
\item{data}{A list of data objects with the same number of samples. See details.}

\item{M}{the required dimension of the fit, a non-negative integer}

\item{covariates}{a dataframe of n samples with sample-specific variables.}

\item{distributions}{a character vector describing which distributional
assumption should be used. See details.}

\item{compositional}{A logical vector with the same length as "data",
indicating if the datasets should be treated as compositional}

\item{maxIt}{an integer, the maximum number of iterations}

\item{tol}{A small scalar, the convergence tolerance}

\item{verbose}{Logical. Should verbose output be printed to the console?}

\item{prevCutOff}{a scalar, the prevalance cutoff for the trimming.}

\item{minFraction}{a scalar, each taxon's total abundance
should equal at least the number of samples n times minFraction,
  otherwise it is trimmed.}

\item{logTransformGaussian}{A boolean, should the gaussian data be
logtransformed, i.e. are they log-normal?}

\item{confounders}{A dataframe or a list of dataframes with the same
length as data.
 In the former case the same dataframe is used for conditioning,
 In the latter case each view has its own conditioning variables (or NULL).}

\item{compositionalConf}{A logical vector with the same length as "data",
indicating if the datasets should be treated as compositional when
correcting for confounders. Numerical problems may occur when set to TRUE}

\item{nleq.control}{A list of arguments to the nleqslv function}

\item{record}{A boolean, should intermediate estimates be stored?
Can be useful to check convergence}

\item{weights}{A character string, either 'marginal' or 'uniform', indicating
rrhow the feature parameters should be weighted in the normalization}

\item{fTol}{The tolerance for solving the estimating equations}

\item{meanVarFit}{The type of mean variance fit, see details}

\item{maxFeats}{The maximal number of features for a Newton-Raphson procedure
to be feasible}

\item{dispFreq}{An integer, the period after which the variances should be
reestimated}

\item{allowMissingness}{A boolean, should NA values be allowed?}

\item{biasReduction}{A boolean, should bias reduction be applied to allow for
confounder correction in groups with all zeroes? Not guaranteed to work}

\item{maxItFeat}{Integers, the maximum allowed number of iterations
in the estimation of the feature parameters}

\item{initPower}{The power to be applied to the residual matrix used to
calculate the starting value. Must be positive; can be tweaked in case of numerical problems (i.e. infinite values returned by nleqslv)}
}
\value{
An object of the "combi" class, containing all information on the
data integration and fitting procedure
}
\description{
Perform model-based data integration
}
\details{
Data can be provided as raw matrices with features in the columns, or as phyloseq, SummarizedExperiment or
ExpressionSet objects. Estimation of independence model and view wise parameters can be
parametrized. See ?BiocParallel::bplapply and ?BiocParallel::register.
meanVarFit = "spline" yields a cubic spline fit for the abundance-variance
 trend, "cubic" gives a third degree polynomial. Both converge to the
 diagonal line with slope 1 for small means.
 Distribution can be either "quasi" for quasi likelihood or "gaussian" for
  Gaussian data
}
\examples{
data(Zhang)
#The method works on several datasets at once, and simply is not very fast.
#Hence the "Not run" statement
\dontrun{
#Unconstrained
microMetaboInt = combi(
list("microbiome" = zhangMicrobio, "metabolomics" = zhangMetabo),
distributions = c("quasi", "gaussian"), compositional = c(TRUE, FALSE),
logTransformGaussian = FALSE, verbose = TRUE)
#Constrained
microMetaboIntConstr = combi(
    list("microbiome" = zhangMicrobio, "metabolomics" = zhangMetabo),
    distributions = c("quasi", "gaussian"), compositional = c(TRUE, FALSE),
    logTransformGaussian = FALSE, covariates = zhangMetavars, verbose = TRUE)
    }
}
