\name{select_partition_number-ConsensusPartition-method}
\alias{select_partition_number,ConsensusPartition-method}
\alias{select_partition_number}
\title{
Several plots for determining the optimized number of subgroups
}
\description{
Several plots for determining the optimized number of subgroups
}
\usage{
\S4method{select_partition_number}{ConsensusPartition}(object, mark_best = TRUE, all_stats = FALSE)
}
\arguments{

  \item{object}{A \code{\link{ConsensusPartition-class}} object.}
  \item{mark_best}{Whether mark the best k in the plot.}
  \item{all_stats}{Whether to show all statistics that were calculated. Used internally.}

}
\details{
There are following plots made:

\itemize{
  \item eCDF of the consensus matrix under each k, made by \code{\link{plot_ecdf,ConsensusPartition-method}},
  \item \code{\link{PAC}} score,
  \item mean sihouette score,
  \item the \code{\link{concordance}} for each partition to the consensus partition,
  \item area increase of the area under the ECDF of consensus matrix with increasing k,
  \item Rand index for current k compared to k - 1,
  \item Jaccard coefficient for current k compared to k - 1,
}
}
\value{
No value is returned.
}
\author{
Zuguang Gu <z.gu@dkfz.de>
}
\examples{
data(golub_cola)
select_partition_number(golub_cola["ATC", "skmeans"])
}
