% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmapCluster.R
\docType{methods}
\name{heatmapCluster}
\alias{heatmapCluster}
\alias{heatmapCluster,cogena-method}
\title{heatmap of gene expression profilings with cluster indication.}
\usage{
heatmapCluster(
  object,
  method,
  nCluster,
  scale = "row",
  sampleColor = NULL,
  clusterColor = NULL,
  clusterColor2 = NULL,
  heatmapcol = NULL,
  maintitle = NULL,
  printSum = TRUE,
  add2 = TRUE,
  cexCol = NULL,
  ...
)

\S4method{heatmapCluster}{cogena}(
  object,
  method = clusterMethods(object),
  nCluster = nClusters(object),
  scale = "row",
  sampleColor = NULL,
  clusterColor = NULL,
  clusterColor2 = NULL,
  heatmapcol = NULL,
  maintitle = NULL,
  printSum = TRUE,
  add2 = TRUE,
  cexCol = NULL,
  ...
)
}
\arguments{
\item{object}{a genecl or cogena object}

\item{method}{as clMethods in genecl function}

\item{nCluster}{as nClust in cogena function.}

\item{scale}{character indicating if the values should be centered and
scaled in either the row direction or the column direction, or none.
 The default is "row".}

\item{sampleColor}{a color vector with the sample length. The default is 
from topo.colors randomly.}

\item{clusterColor}{a color vector with the cluster length. 
The default is rainbow(nClusters(object)).}

\item{clusterColor2}{a color vector with 2 elements. The default is 
rainbow(2).}

\item{heatmapcol}{col for heatmap. The default is greenred(75).}

\item{maintitle}{a character. like GSExxx. the output of figure will like
"kmeans 3 Clusters GSExxx" in two lines.}

\item{printSum}{print the summary of the number of genes in each cluster. 
Default is TRUE.}

\item{add2}{add 2 clusters information.}

\item{cexCol}{numbers, used as cex.axis in for the column axis labeling.}

\item{...}{other parameters to heatmap.3.}
}
\value{
a gene expression heatmap with Cluster information figure
}
\description{
heatmap of gene expression profilings with cluster-based color indication. 
The direction of DEGs are based on latter Vs former from sample labels. 
For example, labels are as.factor(c("ct", "Disease")), the "Disease" are
latter compared with "ct". Usually, the order is the alphabet.
}
\examples{
data(Psoriasis)
annofile <- system.file("extdata", "c2.cp.kegg.v7.01.symbols.gmt.xz", 
package="cogena")

\dontrun{
genecl_result <- coExp(DEexprs, nClust=2:3, clMethods=c("hierarchical","kmeans"), 
    metric="correlation", method="complete", ncore=2, verbose=TRUE)

clen_res <- clEnrich(genecl_result, annofile=annofile, sampleLabel=sampleLabel)

#summay this cogena object
summary(clen_res)

#heatmapCluster

heatmapCluster(clen_res, "hierarchical", "3")
heatmapcol <- gplots::redgreen(75)
heatmapCluster(clen_res, "hierarchical", "3", heatmapcol=heatmapcol)
}

}
\seealso{
\code{\link{clEnrich}}, \code{\link{heatmap.3}} and
\code{\link{heatmapPEI}}
}
