% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cogena_class.R
\docType{class}
\name{cogena-class}
\alias{cogena-class}
\title{An S4 class to represent co-expressed gene-set enrichment 
analysis result.}
\description{
An S4 class to represent co-expressed gene-set enrichment 
analysis result.
}
\section{Slots}{

\describe{
\item{\code{mat}}{Differentially expressed gene expression profilings. Either a 
numeric matrix, a data.frame, or an ExpressionSet object. Data frames must
contain all numeric columns. In all cases, the rows are the items to be 
clustered (e.g., genes), and the columns are the samples.}

\item{\code{clusterObjs}}{a list contains clustering results.}

\item{\code{Distmat}}{the distance matrix.}

\item{\code{measures}}{a list of the enrichment results.}

\item{\code{upDn}}{the enrichment score for up or down-regulated genes.}

\item{\code{clMethods}}{clustering method.}

\item{\code{labels}}{the label of genes}

\item{\code{nClust}}{A numeric vector giving the numbers of clusters to be 
evaluated. e.g., 2:6 would evaluate the number of clusters ranging from 
2 to 6.}

\item{\code{metric}}{the distance measure to be used. It must be one of 
"euclidean","maximum", "manhattan", "canberra", "binary", 
"pearson", "abspearson", "correlation", "abscorrelation", 
"spearman" or "kendall". Any unambiguous substring can be 
given. In detail, please reference the parameter method in 
amap::Dist. Some of the cluster methods could use only part 
of the metric. Please reference the manual of cogena.}

\item{\code{method}}{For hierarchical clustering (hclust and agnes), the 
agglomeration method used. The default is "complete". Available 
choices are "ward", "single", "complete", and "average".}

\item{\code{annotation}}{logical matrix of biological annotation with row 
be DE gene column be gene sets and value be logical.}

\item{\code{sampleLabel}}{character vector with names are sample names. 
Only used for plotting.}

\item{\code{ncore}}{the number of cores used.}

\item{\code{gmt}}{the gmt file used}

\item{\code{call}}{the called function}
}}

