% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clEnrich_one.R
\name{clEnrich_one}
\alias{clEnrich_one}
\title{Gene set enrichment for clusters (for one clustering method and a certain 
number of clusters)}
\source{
Gene sets are from

1. http://www.broadinstitute.org/gsea/msigdb/index.jsp

2. http://amp.pharm.mssm.edu/Enrichr/
}
\usage{
clEnrich_one(
  genecl_obj,
  method,
  nCluster,
  annofile = NULL,
  sampleLabel = NULL,
  TermFreq = 0
)
}
\arguments{
\item{genecl_obj}{a genecl or cogena object}

\item{method}{as clMethods in genecl function}

\item{nCluster}{as nClust in cogena function}

\item{annofile}{gene set annotation file}

\item{sampleLabel}{sameple Label. Do make the label of interest located after
the control label in the order of factor. See details.}

\item{TermFreq}{a value from [0,1) to filter low-frequence gene sets}
}
\value{
a list containing the enrichment score for each clustering methods 
and cluster numbers included in the genecl_obj
}
\description{
Gene set enrichment for clusters sourced from coExp function. the enrichment
score are based on -log(p) with p from hyper-geometric test.
}
\details{
Gene sets availiable (See vignette for more): 
\itemize{
\item c2.cp.kegg.v7.01.symbols.gmt.xz (From Msigdb)
\item c2.cp.reactome.v7.01.symbols.gmt.xz (From Msigdb)
\item c5.bp.v7.01.symbols.gmt.xz (From Msigdb)
}
}
\examples{

#annotaion
annoGMT <- "c2.cp.kegg.v7.01.symbols.gmt.xz"
annofile <- system.file("extdata", annoGMT, package="cogena")

data(Psoriasis)
clMethods <- c("hierarchical","kmeans","diana","fanny","som","model","sota","pam","clara","agnes")
genecl_result <- coExp(DEexprs, nClust=2:3, clMethods=c("hierarchical","kmeans"), 
    metric="correlation", method="complete", ncore=2, verbose=TRUE)

clen_res <- clEnrich_one(genecl_result, "kmeans", "3", annofile=annofile, sampleLabel=sampleLabel)
clen_res1 <- clEnrich_one(clen_res, "hierarchical", "2", annofile=annofile, sampleLabel=sampleLabel)

}
