% Generated by roxygen2 (4.0.0): do not edit by hand
\name{mlSummarization}
\alias{mlSummarization}
\title{Method for computation of the multi-loci summarization}
\usage{
mlSummarization(object, windowMethod, windowParam, summaryMethod, summaryParam,
  callParam = list(runtype = "ff"), returnValues, saveFile = "mlData")
}
\arguments{
\item{object}{an instance of \code{\link[Biobase:class.ExpressionSet]{ExpressionSet}}}

\item{windowMethod}{Method for combination of neighbouring SNPs.
Possible values are Std and Bps.}

\item{windowParam}{further parameters as the window size}

\item{summaryMethod}{allowed versions for the summarization step are:
Gaussian, Variational, Exact. Default is Variational.}

\item{summaryParam}{The parameters for the summaryMethod. Further information
can be obtained via the according functions:
\code{\link[cn.farms:summarizeFarmsGaussian]{cn.farms}},
\code{\link[cn.farms:summarizeFarmsVariational]{cn.farms}} or
\code{\link[cn.farms:summarizeFarmsExact]{cn.farms}}}

\item{callParam}{Additional parameters for runtype (ff or bm) as well as
cores for parallelization.}

\item{returnValues}{List with return values.}

\item{saveFile}{Name of the file to save.
For possible values see summaryMethod.}
}
\value{
Multi-loci summarized data of an instance of
\code{\link[Biobase:class.ExpressionSet]{ExpressionSet}}
}
\description{
Method for computation of the multi-loci summarization
}
\examples{
load(system.file("exampleData/slData.RData", package = "cn.farms"))
windowMethod <- "std"
windowParam <- list()
windowParam$windowSize <- 5
windowParam$overlap <- TRUE
summaryMethod <- "Variational"
summaryParam <- list()
summaryParam$cyc <- c(20)
mlData <- mlSummarization(slData, windowMethod, windowParam,
        summaryMethod, summaryParam)
assayData(mlData)
}
\author{
Djork-Arne Clevert \email{okko@clevert.de} and
Andreas Mitterecker \email{mitterecker@bioinf.jku.at}
}

