% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R, R/io.R
\name{update.gctx}
\alias{update.gctx}
\alias{update_gctx}
\title{Update the matrix of an existing GCTX file}
\usage{
\method{update}{gctx}(...)

update_gctx(x, ofile, rid = NULL, cid = NULL)
}
\arguments{
\item{...}{arguments passed on to \code{update_gctx}}

\item{x}{an array of data}

\item{ofile}{the filename of the GCTX to update}

\item{rid}{integer indices or character ids of the rows
to update}

\item{cid}{integer indices or character ids of the columns
to update}
}
\value{
silently returns NULL
}
\description{
Update the matrix of an existing GCTX file
}
\details{
Overwrite the rows and columns of \code{ofile} 
as indicated by \code{rid} and \code{cid} respectively.
\code{rid} and \code{cid} can either be integer indices
or character ids corresponding to the row and column ids
in \code{ofile}.
}
\examples{
\dontrun{
m <- matrix(rnorm(20), nrow=10)
# update by integer indices
update_gctx(m, ofile="my.gctx", rid=1:10, cid=1:2)
# update by character ids
row_ids <- letters[1:10]
col_ids <- LETTERS[1:2]
update_gctx(m, ofile="my.gctx", rid=row_ids, cid=col_ids)
}
}
