% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R, R/io.R
\name{parse.gmx}
\alias{parse.gmx}
\alias{parse_gmx}
\title{Read a GMX file and return a list}
\usage{
parse.gmx(...)

parse_gmx(fname)
}
\arguments{
\item{...}{arguments passed on to \code{parse_gmx}}

\item{fname}{the file path to be parsed}
}
\value{
a list of the contents of \code{fname}. See details.
}
\description{
Read a GMX file and return a list
}
\details{
\code{parse_gmx} returns a nested list object. The top
  level contains one list per column in \code{fname}. Each of 
  these is itself a list with the following fields:
  - \code{head}: the name of the data (column in \code{fname})
  - \code{desc}: description of the corresponding data
  - \code{len}: the number of data items
  - \code{entry}: a vector of the data items
}
\examples{
gmx_path <- system.file("extdata", "lm_probes.gmx", package="cmapR")
gmx <- parse_gmx(gmx_path)
str(gmx)

}
\seealso{
Visit \url{http://clue.io/help} for details on the GMX file format

Other CMap parsing functions: 
\code{\link{lxb2mat}()},
\code{\link{parse.gmt}()},
\code{\link{parse.grp}()},
\code{\link{write_gmt}()},
\code{\link{write_grp}()}
}
\concept{CMap parsing functions}
