% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{merge_with_precedence}
\alias{merge_with_precedence}
\title{Merge two \code{\link{data.frame}}s, but where there are common fields
those in \code{x} are retained and those in \code{y} are dropped.}
\usage{
merge_with_precedence(x, y, by, allow.cartesian = TRUE, as_data_frame = TRUE)
}
\arguments{
\item{x}{the \code{\link{data.frame}} whose columns take precedence}

\item{y}{another \code{\link{data.frame}}}

\item{by}{a vector of column names to merge on}

\item{allow.cartesian}{boolean indicating whether it's ok
for repeated values in either table to merge with each other
over and over again.}

\item{as_data_frame}{boolean indicating whether to ensure
the returned object is a \code{\link{data.frame}} instead of a
\code{\link{data.table}}.
This ensures compatibility with GCT object conventions,
that is, the \code{rdesc} and \code{cdesc} slots must be strictly
\code{\link{data.frame}} objects.}
}
\value{
a \code{\link{data.frame}} or \code{\link{data.table}} object
}
\description{
Merge two \code{\link{data.frame}}s, but where there are common fields
those in \code{x} are retained and those in \code{y} are dropped.
}
\examples{
(x <- data.table::data.table(foo=letters[1:10], bar=1:10))
(y <- data.table::data.table(foo=letters[1:10], bar=11:20,
  baz=LETTERS[1:10]))
# the 'bar' column from y will be dropped on merge
cmapR:::merge_with_precedence(x, y, by="foo")

}
\seealso{
data.table::merge
}
\keyword{internal}
