% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{overcluster_test}
\alias{overcluster_test}
\title{compare clustering parameters and classification outcomes}
\usage{
overcluster_test(
  expr,
  metadata,
  ref_mat,
  cluster_col,
  x_col = "UMAP_1",
  y_col = "UMAP_2",
  n = 5,
  ngenes = NULL,
  query_genes = NULL,
  threshold = 0,
  do_label = TRUE,
  do_legend = FALSE,
  newclustering = NULL,
  combine = TRUE
)
}
\arguments{
\item{expr}{expression matrix}

\item{metadata}{metadata including cluster info and
dimension reduction plotting}

\item{ref_mat}{reference matrix}

\item{cluster_col}{column of clustering from metadata}

\item{x_col}{column of metadata for x axis plotting}

\item{y_col}{column of metadata for y axis plotting}

\item{n}{expand n-fold for over/under clustering}

\item{ngenes}{number of genes to use for feature selection,
use all genes if NULL}

\item{query_genes}{vector, otherwise genes with be recalculated}

\item{threshold}{type calling threshold}

\item{do_label}{whether to label each cluster at median center}

\item{do_legend}{whether to draw legend}

\item{newclustering}{use kmeans if NULL on dr
or col name for second column of clustering}

\item{combine}{if TRUE return a single plot with combined panels, if
FALSE return list of plots (default: TRUE)}
}
\value{
faceted ggplot object
}
\description{
compare clustering parameters and classification outcomes
}
\examples{
set.seed(42)
overcluster_test(
    expr = pbmc_matrix_small,
    metadata = pbmc_meta,
    ref_mat = cbmc_ref,
    cluster_col = "classified",
    x_col = "UMAP_1",
    y_col = "UMAP_2"
)
}
