% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groupGO.R
\name{groupGO}
\alias{groupGO}
\title{Functional Profile of a gene set at specific GO level.
Given a vector of genes, this function will return the GO profile at
a specific level.}
\usage{
groupGO(
  gene,
  OrgDb,
  keyType = "ENTREZID",
  ont = "CC",
  level = 2,
  readable = FALSE
)
}
\arguments{
\item{gene}{a vector of entrez gene id.}

\item{OrgDb}{OrgDb}

\item{keyType}{key type of input gene}

\item{ont}{One of "MF", "BP", and "CC" subontologies.}

\item{level}{Specific GO Level.}

\item{readable}{if readable is TRUE, the gene IDs will mapping to gene
symbols.}
}
\value{
A \code{groupGOResult} instance.
}
\description{
Functional Profile of a gene set at specific GO level.
Given a vector of genes, this function will return the GO profile at
a specific level.
}
\examples{

	data(gcSample)
	yy <- groupGO(gcSample[[1]], 'org.Hs.eg.db', ont="BP", level=2)
	head(summary(yy))
	#plot(yy)

}
\seealso{
[groupGOResult-class], [compareCluster]
}
\author{
Guangchuang Yu \url{https://yulab-smu.top}
}
\keyword{manip}
