% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichGO.R
\name{enrichGO}
\alias{enrichGO}
\title{GO Enrichment Analysis of a gene set.
Given a vector of genes, this function will return the enrichment GO
categories after FDR control.}
\usage{
enrichGO(
  gene,
  OrgDb,
  keyType = "ENTREZID",
  ont = "MF",
  pvalueCutoff = 0.05,
  pAdjustMethod = "BH",
  universe,
  qvalueCutoff = 0.2,
  minGSSize = 10,
  maxGSSize = 500,
  readable = FALSE,
  pool = FALSE
)
}
\arguments{
\item{gene}{a vector of entrez gene id.}

\item{OrgDb}{OrgDb}

\item{keyType}{keytype of input gene}

\item{ont}{One of "BP", "MF", and "CC" subontologies, or "ALL" for all three.}

\item{pvalueCutoff}{adjusted pvalue cutoff on enrichment tests to report}

\item{pAdjustMethod}{one of "holm", "hochberg", "hommel", "bonferroni", "BH", "BY", "fdr", "none"}

\item{universe}{background genes. If missing, the all genes listed in the database (eg TERM2GENE table) will be used as background.}

\item{qvalueCutoff}{qvalue cutoff on enrichment tests to report as significant.  Tests must pass i) \code{pvalueCutoff} on unadjusted pvalues, ii) \code{pvalueCutoff} on adjusted pvalues and iii) \code{qvalueCutoff} on qvalues to be reported.}

\item{minGSSize}{minimal size of genes annotated by Ontology term for testing.}

\item{maxGSSize}{maximal size of genes annotated for testing}

\item{readable}{whether mapping gene ID to gene Name}

\item{pool}{If ont='ALL', whether pool 3 GO sub-ontologies}
}
\value{
An \code{enrichResult} instance.
}
\description{
GO Enrichment Analysis of a gene set.
Given a vector of genes, this function will return the enrichment GO
categories after FDR control.
}
\examples{
\dontrun{
  data(geneList, package = "DOSE")
	de <- names(geneList)[1:100]
	yy <- enrichGO(de, 'org.Hs.eg.db', ont="BP", pvalueCutoff=0.01)
	head(yy)
}
}
\seealso{
[enrichResult-class], [compareCluster]
}
\author{
Guangchuang Yu \url{https://yulab-smu.top}
}
\keyword{manip}
