% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adaptiveSmoothing.R
\name{adaptiveSmoothing}
\alias{adaptiveSmoothing}
\title{Adaptive smoothing}
\usage{
adaptiveSmoothing(spe, nnCells, NN = 30, kernel = "G", spread = 0.3)
}
\arguments{
\item{spe}{SpatialExperiment object containing neighbourhood entropy values
of each cell.}

\item{nnCells}{a character matrix of NN nearest neighbours - rows are index
cells and columns are their nearest neighbours ranging from closest to
farthest neighbour. For sort = TRUE, the neighbours belonging to the same
initial cluster as the index cell are moved closer to it.}

\item{NN}{an integer for the number of neighbouring cells the function
should consider. The value must be greater than or equal to 1. Default value
is 30.}

\item{kernel}{a character for type of distribution to be used. The two valid
values are "G" or "E" for Gaussian and exponential distributions,
respectively. Default value is "G".}

\item{spread}{a numeric value for distribution spread, represented by
standard deviation for Gaussian distribution and rate for exponential
distribution. Default value is 0.3 for Gaussian distribution. The recommended
value is 5 for exponential distribution.}
}
\value{
SpatialExperiment object including smoothed gene expression as an
additional assay.
}
\description{
A function to perform a weighted, adaptive smoothing of the gene expression
of each cell based on the heterogeneity of its neighbourhood. Heterogeneous
neighbourhoods are smoothed less with higher weights given to cells belonging
to same initial cluster as the index cell. Homogeneous neighbourhoods are
smoothed more with similar weights given to most cells.
}
\examples{
data(ClustSignal_example)

# requires matrix containing NN nearest neighbour cell labels (nnCells),
# generated using the neighbourDetect() function
spe <- clustSIGNAL::adaptiveSmoothing(spe, nnCells)
spe
}
