% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMirSites.R
\name{rearrangeMiRres}
\alias{rearrangeMiRres}
\title{Rearrange miR results}
\usage{
rearrangeMiRres(miRsites)
}
\arguments{
\item{miRsites}{A list containing the miR sites found in the RNA
target sequence. it can be generated with \code{\link{getMiRsites}}.}
}
\value{
A list.
}
\description{
The function rearrangeMiRres() rearranges the results of the
getMiRsites() function. Each element of the list contains the miR results
relative to one circRNA. For each circRNA only miRNAs for which at least 1
miRNA binding site is found are reported.
}
\examples{
# Load data frame containing predicted back-spliced junctions
data("mergedBSJunctions")

# Load short version of the gencode v19 annotation file
data("gtf")

# Annotate the first back-spliced junctions
annotatedBSJs <- annotateBSJs(mergedBSJunctions[1, ], gtf)

# Get genome
genome <- BSgenome::getBSgenome("BSgenome.Hsapiens.UCSC.hg19")

# Retrieve target sequences.
 targets <- getCircSeqs(
     annotatedBSJs,
     gtf,
     genome)

# Screen target sequence for miR binding sites.
pathToMiRs <- system.file("extdata", "miRs.txt",package="circRNAprofiler")

# miRsites <- getMiRsites(
#    targets,
#    miRspeciesCode = "hsa",
#    miRBaseLatestRelease = TRUE,
#    totalMatches = 6,
#    maxNonCanonicalMatches = 1,
#    pathToMiRs)

# Rearrange miR results
# rearragedMiRres <- rearrangeMiRres(miRsites)


}
