% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPlots.R
\name{plotMotifs}
\alias{plotMotifs}
\title{Plot motifs analysis results}
\usage{
plotMotifs(
  mergedMotifsFTS,
  mergedMotifsBTS,
  log2FC = 1,
  n = 0,
  removeNegLog2FC = FALSE,
  nf1 = 1,
  nf2 = 1,
  df1Name = "foreground",
  df2Name = "background",
  angle = 0
)
}
\arguments{
\item{mergedMotifsFTS}{A data frame containing the number of occurences
of each motif found in foreground target sequences (e.g from detected
back-spliced junctions). It can be generated with the
\code{\link{mergeMotifs}}.}

\item{mergedMotifsBTS}{A data frame containing the number of occurences
of each motif found in the background target sequences (e.g. from
random back-spliced junctions). It can be generated with the
\code{\link{mergeMotifs}}.}

\item{log2FC}{An integer specifying the log2FC cut-off. Default value is 1.

NOTE: log2FC is calculated as follow: normalized number of occurences of
each motif found in the foreground target sequences / normalized number of
occurences of each motif found in the background target sequences.

To avoid infinity as a value for fold change, 1 was added to number of occurences
of each motif found in the foreground and background target sequences before
the normalization.}

\item{n}{An integer specifying the number of motifs cutoff.
E.g. if 3 is specifiyed only motifs that are found at least 3 times in the
foreground or background target sequences are retained.
Deafaut value is 0.}

\item{removeNegLog2FC}{A logical specifying whether to remove the RBPs having
a negative log2FC. If TRUE then only positive log2FC will be visualized.
Default value is FALSE.}

\item{nf1}{An integer specifying the normalization factor for the
first data frame mergedMotifsFTS. The occurrences of each motif plus 1 are
divided by nf1. The normalized values are then used for fold-change calculation.
Set this to the number or length of target sequences (e.g from detected
back-spliced junctions) where the motifs were extracted from.
Default value is 1.}

\item{nf2}{An integer specifying the normalization factor for the
second data frame mergedMotifsBTS. The occurrences of each motif plus 1 are
divided by nf2. The The normalized values are then used for fold-change calculation.
Set this to the number of target sequences (e.g from random
back-spliced junctions) where the motifs were extracted from.
Default value is 1.

NOTE: If nf1 and nf2 is set equals to 1, the number or length of target sequences
(e.g detected Vs randomly selected) where the motifs were extrated from,
is supposed to be the same.}

\item{df1Name}{A string specifying the name of the first data frame. This
will be displayed in the legend of the plot. Deafult value is "foreground".}

\item{df2Name}{A string specifying the name of the first data frame. This
will be displayed in the legend of the plot. Deafult value is "background".}

\item{angle}{An integer specifying the rotation angle of the axis labels.
Default value is 0.}
}
\value{
A ggplot object.
}
\description{
The function plotMotifs() generates 2 bar charts showing the
log2FC and the number of occurences of each motif found in the target
sequences (e.g detected Vs randomly selected).
}
\examples{
# Load data frame containing detected back-spliced junctions
data("mergedBSJunctions")

# Load short version of the gencode v19 annotation file
data("gtf")

# Annotate the first back-spliced junctions
annotatedFBSJs <- annotateBSJs(mergedBSJunctions[1, ], gtf)

# Get random back-spliced junctions
randomBSJunctions <- getRandomBSJunctions(gtf, n = 1, f = 10)

# Annotate random back-spliced junctions
annotatedBBSJs <- annotateBSJs(randomBSJunctions, gtf, isRandom = TRUE)

# Get genome
genome <- BSgenome::getBSgenome("BSgenome.Hsapiens.UCSC.hg19")

# Retrieve target sequences from detected back-spliced junctions
targetsFTS <- getSeqsFromGRs(
   annotatedFBSJs,
   genome,
   lIntron = 200,
   lExon = 10,
   type = "ie"
   )

# Retrieve target sequences from random back-spliced junctions
targetsBTS <- getSeqsFromGRs(
   annotatedBBSJs,
   genome,
   lIntron = 200,
   lExon = 10,
   type = "ie"
   )

# Get motifs
 motifsFTS <- getMotifs(
     targetsFTS,
     width = 6,
     database = 'ATtRACT',
     species = "Hsapiens",
     rbp = TRUE,
     reverse = FALSE)

motifsBTS <- getMotifs(
     targetsBTS,
     width = 6,
     database = 'ATtRACT',
     species = "Hsapiens",
     rbp = TRUE,
     reverse = FALSE)

# Merge motifs
 mergedMotifsFTS <- mergeMotifs(motifsFTS)
 mergedMotifsBTS <- mergeMotifs(motifsBTS)

# Plot
 p <- plotMotifs(
     mergedMotifsFTS,
     mergedMotifsBTS,
     log2FC = 2,
     nf1 = nrow(annotatedFBSJs),
     nf2 = nrow(annotatedBBSJs),
     df1Name = "foreground",
     df2Name = "background")

}
