% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_inputs.R
\name{getSampleDepths}
\alias{getSampleDepths}
\title{getSampleDepths}
\usage{
getSampleDepths(
  alignment_files,
  paired = TRUE,
  by_rg = FALSE,
  format = c("bam", "bed")
)
}
\arguments{
\item{alignment_files}{filenames for bam or bed file(s) with aligned reads}

\item{paired}{paired end data?}

\item{by_rg}{use RG tags to separate groups?}

\item{format}{bam or bed format? default is bam}
}
\value{
numeric vector
}
\description{
makes vector of read depths in bam files or RG groups within bam files
}
\examples{

# With single bam with RG tags (can also give multiple bams with RG)
test_rg <- system.file("extdata", "test_RG.bam", package = "chromVAR")
test_counts <- getSampleDepths(test_rg,  by_rg = TRUE, 
                          paired = TRUE)
                          

# Multiple bams without RG tags
test_bam1 <- system.file("extdata", "test_single1.bam", package = "chromVAR")
test_bam2 <- system.file("extdata", "test_single2.bam", package = "chromVAR")
test_bam3 <- system.file("extdata", "test_single3.bam", package = "chromVAR")
test_counts2 <- getSampleDepths(c(test_bam1, test_bam2,test_bam3), 
                           by_rg = FALSE, 
                           paired = TRUE) 
                           
}
\seealso{
\code{\link{getCounts}},  \code{\link{filterSamples}}
}
