% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_inputs.R
\name{getPeaks}
\alias{getPeaks}
\title{getPeaks}
\usage{
getPeaks(filename, extra_cols = c(), sort_peaks = FALSE)
}
\arguments{
\item{filename}{filename of bed file}

\item{extra_cols}{extra columns to read in beyond first three}

\item{sort_peaks}{sort the peaks?}
}
\value{
\code{\link[GenomicRanges]{GenomicRanges}} containing peaks from file
}
\description{
Read in peaks from a bed file.
}
\details{
As in standard definition of bed file, first column is assumed to be
 chromosome, second is assumed to be start of peak (0-based), and third is
 assumed to be end of peak (1-based). Note that in output GenomicRanges
 output, start and end indices are both 1-based. Extra columns can be added
 as metadata or strand information if provided, but the user must indicate 
 column index and name using named vector for extra_cols.
}
\examples{
peaks_file <- system.file("extdata", "test_bed.txt", package = "chromVAR")
peaks <- getPeaks(peaks_file, sort = TRUE)
}
\seealso{
\code{\link{getCounts}}, \code{\link{filterPeaks}}, 
\code{\link{readNarrowpeaks}}
}
