% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_annotations.R
\name{getAnnotations}
\alias{getAnnotations}
\alias{getAnnotations,GRangesList-method}
\alias{getAnnotations,MatrixOrmatrix-method}
\alias{getAnnotations,data.frame-method}
\alias{getAnnotations,list-method}
\alias{getAnnotations,character-method}
\title{getAnnotations}
\usage{
getAnnotations(annotations, ...)

\S4method{getAnnotations}{GRangesList}(annotations, rowRanges, ...)

\S4method{getAnnotations}{MatrixOrmatrix}(annotations, ...)

\S4method{getAnnotations}{data.frame}(annotations, ...)

\S4method{getAnnotations}{list}(annotations, npeaks = NULL, ...)

\S4method{getAnnotations}{character}(annotations, rowRanges, column = NULL, ...)
}
\arguments{
\item{annotations}{matrix, Matrix, or data.frame of fragment counts,
or SummarizedExperiment with counts assays, see details}

\item{...}{additional arguments to pass to SummarizedExperiment}

\item{rowRanges}{GenomicRanges or GenomicRangesList or 
RangedSummarizedExperiment}

\item{npeaks}{number of peaks}

\item{column}{column of bed file with annotation names, see details}
}
\value{
SummarizedExperiment object with 'matches' assay
}
\description{
getAnnotations
}
\section{Methods (by class)}{
\itemize{
\item \code{getAnnotations(GRangesList)}: get annotation matrix from GRangesList

\item \code{getAnnotations(MatrixOrmatrix)}: get annotation matrix from Matrix or matrix

\item \code{getAnnotations(data.frame)}: get annotation matrix from data.frame

\item \code{getAnnotations(list)}: get annotation matrix from list

\item \code{getAnnotations(character)}: get annotations from bed files

}}
\examples{

# First get example counts
data(mini_counts, package = "chromVAR")

# Get annotations from genomic ranges list
library(GenomicRanges)
library(SummarizedExperiment)
my_annotation_granges <- GRangesList(GRanges("chr1", 
                                             ranges = IRanges(start = 
                                             c(566763,805090), width = 8)),
                                     GRanges("chr1", ranges = IRanges(start =
                                               c(566792,895798), width = 8)))
anno_ix <- getAnnotations(my_annotation_granges, 
                           rowRanges = rowRanges(mini_counts))
}
\author{
Alicia Schep
}
