% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimensionality_reduction.R
\name{deviationsTsne}
\alias{deviationsTsne}
\title{deviationsTsne}
\usage{
deviationsTsne(
  object,
  threshold = 1.5,
  perplexity = if (what == "samples") 30 else 8,
  max_iter = 1000,
  theta = 0.5,
  what = c("samples", "annotations"),
  shiny = FALSE
)
}
\arguments{
\item{object}{deviations result}

\item{threshold}{variability threshold -- use only deviations with 
variability greater than threshold}

\item{perplexity}{perplexity parameter for tsne}

\item{max_iter}{max iterations parameter for tsne}

\item{theta}{theta parameter for tsne}

\item{what}{tsne for similarity of samples or annotations?}

\item{shiny}{load a shiny widget that enable you to explore perplexity and 
variability threshold parameter?}
}
\value{
data.frame with two columns for the two dimensions of tSNE output
}
\description{
Perform tsne using bias corrected deviations to visualize either cell/sample
similarity or motif/kmer/annotation similarity
}
\examples{
# Load very small example results from computeDeviations
data(mini_dev, package = "chromVAR")
                         
tsne_res <- deviationsTsne(mini_dev, threshold = 0.8, shiny = FALSE)
# setting very low variabilitiy threshold because this is mini data set
# threshold should generally be above 1
# Use plotVariability to get a sense of an appropriate threshold
}
\author{
Alicia Schep
}
