% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{read_bed}
\alias{read_bed}
\title{Read files containing peaks or genomic regions}
\usage{
read_bed(file_path)
}
\arguments{
\item{file_path}{A path to a file with input peaks/regions. See extended
description above for details about file support.}
}
\value{
A \code{GRanges} with \code{mcols} matching any extra columns.
}
\description{
The following formats are fully supported via their file extensions: .bed,
.broadPeak, .narrowPeak, .gff3, .gff2, .gff, and .bedGraph or .bdg. BED3 through
BED6 files are supported under the .bed extension. Files without these extensions
are supported under the conditions that the first 3 columns correspond to
chr, start, and end and that there is either no header column, or it is
commented out. Files may be compressed with gzip, and so might end in .narrowPeak.gz,
for example. For files with extension support, the \code{rtracklayer::import()}
function is used to read peaks, so adherence to the mentioned file formats is
necessary.
}
\details{
NOTE: Header rows must be commented with \code{#} to be ignored. Otherwise,
an error may result.

NOTE: A warning is given if any input regions overlap. In the case of enrichment
testing with \code{method = 'broadenrich'}, regions should be disjoint.

Typically, this function will not be used alone, but inside \code{chipenrich()}.
}
\examples{

# Example of generic .txt file with peaks
file = system.file('extdata', 'test_header.txt', package = 'chipenrich')
peaks = read_bed(file)

# Example of BED3
file = system.file('extdata', 'test_assign.bed', package = 'chipenrich')
peaks = read_bed(file)

# Example of narrowPeak
file = system.file('extdata', 'test.narrowPeak', package = 'chipenrich')
peaks = read_bed(file)

# Example of gzipped broadPeak
file = system.file('extdata', 'test.broadPeak.gz', package = 'chipenrich')
peaks = read_bed(file)

# Example of gzipped gff3 Fly peaks
file = system.file('extdata', 'test.gff3.gz', package = 'chipenrich')
peaks = read_bed(file)

}
