% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{select_transcript}
\alias{select_transcript}
\title{Select which transcript to use (for plotting) for a GenePartner object}
\usage{
select_transcript(gene_partner, which_transcripts = "exonBoundary")
}
\arguments{
\item{gene_partner}{The GenePartner object to select a transcript for.}

\item{which_transcripts}{This character vector decides which transcripts are
to be plotted. Can be "exonBoundary", "withinExon", "withinIntron",
"intergenic", or a character vector with specific transcript ids. Default
value is "exonBoundary".}
}
\value{
A data.frame with transcript data.
}
\description{
This function takes a GenePartner object and creates a transcript data.frame
with transcript information, including only the transcripts given by the
parameter which_transcripts
}
\details{
select_transcript() selects which transcript to create by this prioritization:

1. Exon boundary transcripts.
2. Within exon transcripts.
3. Within intron transcripts.
4. Intergenic transcripts.
}
\examples{
# Load data and example fusion event
defuse833ke <- system.file(
  "extdata",
  "defuse_833ke_results.filtered.tsv",
  package="chimeraviz")
fusions <- import_defuse(defuse833ke, "hg19", 1)
fusion <- get_fusion_by_id(fusions, 5267)
# Load edb
edbSqliteFile <- system.file(
  "extdata",
  "Homo_sapiens.GRCh37.74.sqlite",
  package="chimeraviz")
edb <- ensembldb::EnsDb(edbSqliteFile)
# Get transcripts
fusion <- get_transcripts_ensembl_db(fusion, edb)
# Select transcript
transcriptsA <- select_transcript(upstream_partner_gene(fusion))

}
