% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fusion_reads.R
\name{plot_fusion_reads}
\alias{plot_fusion_reads}
\title{Create a plot of the reads supporting the given fusion.}
\usage{
plot_fusion_reads(fusion, show_all_nucleotides = TRUE, nucleotide_amount = 10)
}
\arguments{
\item{fusion}{The Fusion object to plot.}

\item{show_all_nucleotides}{Boolean indicating whether or not to show all
nucleotides. If FALSE, then only nucleotide_amount amount of nucleotides will
be shown on each end of the fusion junction. If TRUE, then the whole fusion
junction sequence will be shown.}

\item{nucleotide_amount}{The number of nucleotides to show on each end of the
fusion junction sequence. Defaults to 10. Only applicable if
show_all_nucleotides is set to TRUE.}
}
\value{
Creates a fusion reads plot.
}
\description{
This function takes a Fusion object and plots the reads supporting the fusion
on top of the fusion sequence (fusion@junction_sequence), provided that
add_fusion_reads_alignment() has been run earlier in order to add fusion reads
alignment data to the fusion object.
}
\details{
Note that the package used for plotting, Gviz, is strict on chromosome names.
If the plot produced doesn't show the reads, the problem might be solved by
naming the fusion sequence "chrNA".
}
\examples{
# Load data
defuseData <- system.file(
  "extdata",
  "defuse_833ke_results.filtered.tsv",
  package="chimeraviz")
fusions <- import_defuse(defuseData, "hg19", 1)
# Find the specific fusion we have aligned reads for
fusion <- get_fusion_by_id(fusions, 5267)
bamfile <- system.file(
  "extdata",
  "5267readsAligned.bam",
  package="chimeraviz")
# Add the bam file of aligned fusion reads to the fusion object
fusion <- add_fusion_reads_alignment(fusion, bamfile)
# Temporary file to store the plot
pngFilename <- tempfile(
  pattern = "fusionPlot",
  fileext = ".png",
  tmpdir = tempdir())
# Calculate image size based on supporting reads and lenght of junction
# sequence.
imageWidth <- (nchar(partner_gene_junction_sequence(upstream_partner_gene(fusion))) +
  nchar(partner_gene_junction_sequence(downstream_partner_gene(fusion)))) * 15
imageHeight <- (fusion_split_reads_count(fusion)+fusion_spanning_reads_count(fusion)) * 20
# Open device
png(pngFilename, width = imageWidth, height = imageHeight)
# Now we can plot
plot_fusion_reads(fusion)
# Close device
dev.off()

}
\seealso{
add_fusion_reads_alignment
}
