% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_defuse.R
\name{import_defuse}
\alias{import_defuse}
\title{Import results from a deFuse run into a list of Fusion objects.}
\usage{
import_defuse(filename, genome_version, limit)
}
\arguments{
\item{filename}{Filename for the deFuse results .tsv file.}

\item{genome_version}{Which genome was used in mapping (hg19, hg38, etc.).}

\item{limit}{A limit on how many lines to read.}
}
\value{
A list of Fusion objects.
}
\description{
A function that imports the results from a deFuse run, typically from a
results.filtered.tsv file, into a list of Fusion objects.
}
\examples{
defuse833ke <- system.file(
  "extdata",
  "defuse_833ke_results.filtered.tsv",
  package="chimeraviz")
fusions <- import_defuse(defuse833ke, "hg19", 3)
# This should import a list of 3 fusions described in Fusion objects.
}
