% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{Fusion-class}
\alias{Fusion-class}
\alias{Fusion}
\title{An S4 class to represent a fusion event.}
\description{
The Fusion class represents a fusion event, holding data imported from a
fusion tool.
}
\section{Slots}{

\describe{
\item{\code{id}}{A unique id representing a fusion event. For deFuse data this will
be the cluster id.}

\item{\code{fusion_tool}}{Name of the fusion tool.}

\item{\code{genome_version}}{Name of the genome used to map reads.}

\item{\code{spanning_reads_count}}{The number of spanning reads supporting the
fusion.}

\item{\code{split_reads_count}}{The number of split reads supporting the fusion.}

\item{\code{fusion_reads_alignment}}{A Gviz::AlignmentsTrack object holding the
fusion reads aligned to the fusion sequence.}

\item{\code{gene_upstream}}{A PartnerGene object holding information of the upstream
fusion partner gene.}

\item{\code{gene_downstream}}{A PartnerGene object holding information of the
downstream fusion partner gene.}

\item{\code{inframe}}{A logical value indicating whether or not the downstream
fusion partner gene is inframe or not. Not all fusion-finders report this.}

\item{\code{fusion_tool_specific_data}}{A list that will hold fields of importance
for a specific fusion finder. This field is used because many fusion-finders
report important values that are hard to fit into a standardized format.
Examples of values that are added to this list is probability from deFuse
and EricScore from EricScript.}
}}

