% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DelayedNaryIsoOp.R
\name{saveDelayedObject,DelayedNaryIsoOp-method}
\alias{saveDelayedObject,DelayedNaryIsoOp-method}
\title{Saving a DelayedNaryIsoOp}
\usage{
\S4method{saveDelayedObject}{DelayedNaryIsoOp}(x, file, name)
}
\arguments{
\item{x}{A \linkS4class{DelayedNaryIsoOp} object.}

\item{file}{String containing the path to a HDF5 file.}

\item{name}{String containing the name of the group to save into.}
}
\value{
A \code{NULL}, invisibly.
A group is created at \code{name} containing the contents of the DelayedNaryIsoOp.
}
\description{
Save a \linkS4class{DelayedNaryIsoOp} object into a HDF5 file.
See the \dQuote{Binary ...} operations at \url{https://artifactdb.github.io/chihaya/} for more details.
}
\examples{
X <- DelayedArray(matrix(runif(100), ncol=5))
Y <- DelayedArray(matrix(runif(100), ncol=5))
Z <- X * Y
temp <- tempfile(fileext=".h5")
saveDelayed(Z, temp)
rhdf5::h5ls(temp)
loadDelayed(temp)

}
\author{
Aaron Lun
}
