% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segmentByPSCB.R
\name{segmentByPSCB}
\alias{segmentByPSCB}
\title{Segmentation data with PSCBS}
\usage{
segmentByPSCB(sample_transformed_sl)
}
\arguments{
\item{sample_transformed_sl}{dataframe of z-transformed SLRatio}
}
\value{
Dataframe of segmentation result
}
\description{
Segmentation data with PSCBS
}
\examples{
### Loading example SampleBam file
example_file <-  system.file("extdata","example_patientcfDNA_SampleBam.RDS",package = "cfdnakit")
sample_bambin <- readRDS(example_file)
### Example PoN
PoN_rdsfile <- system.file("extdata","ex.PoN.rds",package = "cfdnakit")
pon_profiles <- readRDS(PoN_rdsfile)
sample_profile <- get_fragment_profile(sample_bambin,sample_id = "Patient1")

sample_zscore <- get_zscore_profile(sample_profile,pon_profiles)
sample_zscore_segment <- segmentByPSCB(sample_zscore)

}
