% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MergeCpGs.R
\name{MergeCpGs}
\alias{MergeCpGs}
\title{Generate fragment-level methylation states of CpGs}
\usage{
MergeCpGs(CpG_OT, CpG_OB, output.dir = "", id = "")
}
\arguments{
\item{CpG_OT}{a file of methylation information for CpG on the 
original top strand (OT), 
which is one of the outputs from `bismark methylation extractor`.}

\item{CpG_OB}{a file of methylation information for CpG on the 
original bottom strand (OB), 
which is one of the outputs from `bismark methylation extractor`.}

\item{output.dir}{a path to the output directory. Default is "", 
which means the output will not be written into a file.}

\item{id}{an ID name for the input data. Default is "", 
which means the output will not be written into a file.}
}
\value{
a list in BED file format and/or written to 
an output BED file.
}
\description{
Merge the methylation states of all CpGs corresponding to the 
same fragment onto one line in output.
}
\examples{
## input files
demo.dir <- system.file("data", package="cfTools")
CpG_OT <- file.path(demo.dir, "CpG_OT_demo.txt.gz")
CpG_OB <- file.path(demo.dir, "CpG_OB_demo.txt.gz")

output <- MergeCpGs(CpG_OT, CpG_OB)

}
