% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_functions_v8.R
\name{visualizeTrcks}
\alias{visualizeTrcks}
\title{Visualize Cell Tracks}
\usage{
visualizeTrcks(
  tracks,
  width_px,
  height_px,
  i.slice = 1,
  pnt.cex = 1.2,
  lwd = 1.2,
  col = "red"
)
}
\arguments{
\item{tracks}{cell tracks}

\item{width_px}{width in pixels}

\item{height_px}{height in pixels}

\item{i.slice}{index of the stack slice to use}

\item{pnt.cex}{cex for the points (circles) drawn around the cells}

\item{lwd}{lwd of cell tracks}

\item{col}{color used for the cell tracks, .g. "red"}
}
\value{
None
}
\description{
Annotates an image with cell centroids by adding cell ROIs
and drawing cell tracks
}
\examples{
x1 <- data.frame(c(10, 30, 25, 55, 43, 39, 75, 72),
                 c(22, 28, 35, 24, 31, 39, 65, 73),
                 c( 1,  2,  3,  4,  5,  6,  7,  8),
                 c( 1,  1,  1,  1,  1,  1,  1,  1))
plot(2, 2, xlim = c(0,1), ylim = c(0,1), xlab = "", ylab = "", las = 2)
cellmigRation:::visualizeTrcks(x1, width_px = 100, height_px = 100)


}
\references{
\url{https://www.data-pulse.com/dev_site/cellmigration/}
\url{https://www.mathworks.com/matlabcentral/fileexchange/60349-fasttracks}
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
\keyword{internal}
