% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_functions_v8.R
\name{bpass}
\alias{bpass}
\title{Perform a bandpass by convolving with an appropriate kernel}
\usage{
bpass(image_array, lnoise, lobject = NULL, threshold)
}
\arguments{
\item{image_array}{Numeric matrix corresponding to the image to be
filtered}

\item{lnoise}{Characteristic lengthscale of noise in pixels.}

\item{lobject}{Integer length in pixels somewhat larger than
a typical object}

\item{threshold}{By default, after the convolution, any negative
pixels
are reset to 0. Threshold changes the threshhold for setting
pixels
to 0. Positive values may be useful for removing
stray noise or small particles.}
}
\value{
Numeric matrix corresponding to the filtered image
}
\description{
Implements a real-space bandpass filter that suppresses pixel noise
and
long-wavelength
image variations while retaining information of a characteristic
size.
First, a lowpassed image is produced by convolving the original
with
a gaussian.
Next, a second lowpassed image is produced by convolving the
original
with a
boxcar function. By subtracting the boxcar version from
the gaussian version,
we are using the boxcar version to perform a highpass.
This code 'bpass.pro' is copyright 1997, John C. Crocker and
David G. Grier.    It should be considered 'freeware'- and may be
distributed freely in its original form when properly attributed.
}
\examples{
x0 <- cbind(
    c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
    c(0, 0, 0, 0, 0, 1, 1, 4, 2, 0, 0, 0, 0, 0, 0),
    c(0, 0, 0, 0, 1, 2, 6, 5, 3, 0, 0, 0, 1, 0, 0),
    c(0, 0, 0, 0, 5, 5, 6, 8, 6, 1, 0, 0, 6, 2, 0),
    c(0, 0, 2, 5, 8, 7, 3, 5, 1, 0, 0, 0, 6, 2, 0),
    c(0, 0, 1, 5, 8, 7, 4, 5, 2, 0, 0, 0, 0, 0, 0),
    c(0, 0, 0, 5, 8, 7, 4, 5, 2, 0, 0, 0, 0, 0, 0),
    c(0, 0, 0, 1, 4, 5, 2, 4, 0, 0, 0, 0, 0, 0, 0),
    c(0, 0, 0, 0, 2, 3, 2, 1, 0, 0, 0, 0, 0, 0, 0),
    c(0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0),
    c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0),
    c(9, 9, 9, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 2, 1),
    c(2, 9, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 2, 1),
    c(0, 2, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0),
    c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
    c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0))
y0 <- cellmigRation:::bpass(x0, lnoise = 1, lobject = 5, threshold = 1)
par(mfrow = c(1, 2))
image(x0); title("original")
image(y0); title("after bpass")

}
\references{
\url{https://www.data-pulse.com/dev_site/cellmigration/}
\url{https://www.mathworks.com/matlabcentral/fileexchange/60349-fasttracks}
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
\keyword{internal}
