% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_functions_v8.R
\name{aggregateFR}
\alias{aggregateFR}
\title{Aggregating the outcome of several experiments or conditions.}
\usage{
aggregateFR(x, ..., export = FALSE)
}
\arguments{
\item{x}{\code{CellMig} class object, which is a list of data
frames resulted from the PreProcessing.}

\item{...}{one or more CellMig-class object(s) where cells'
trajectories have already been analyzed.}

\item{export}{if `TRUE` (default), exports function output to CSV
file}
}
\value{
two data frames:
The first data frame shows the average of each parameter per
experiment/condition.
The second data frame shows the parameters of individual cells
of all experiments/conditions.
}
\description{
Aggregate two or more CellMig-class objects together.
Input objects must carry information of trajectory analyses
(otherwise an error will be raised).
All trajectory results form the different experiments/conditions
are returned in two data frames.
}
\details{
The visualization shows centered trajectories where the
starting point of each track is located at the origin of the
coordinate system (X=0,Y=0).
}
\examples{
data(WSADataset)
wasDF1 <- WSADataset[seq(1,300,by=1), ]
wsaTD1 <- CellMig(wasDF1)
wsaTD1 <- wsaPreProcessing(wsaTD1,FrameN=55)
wsaTD1 <-FMI(wsaTD1,TimeInterval=10)
wsaTD1 <-FinRes(wsaTD1,ParCor=FALSE, export=FALSE)
wasDF2 <- WSADataset[seq(500,700,by=1), ]
wsaTD2 <- CellMig(wasDF2)
wsaTD2 <- wsaPreProcessing(wsaTD2,FrameN=55)
wsaTD2 <-FMI(wsaTD2,TimeInterval=10)
wsaTD2 <-FinRes(wsaTD2,ParCor=FALSE, export=FALSE)
AGG<-aggregateFR(wsaTD1 ,wsaTD2 ,export=FALSE)


}
\references{
\url{https://www.data-pulse.com/dev_site/cellmigration/}
}
\author{
Damiano Fantini and
Salim Ghannoum \email{salim.ghannoum@medisin.uio.no}
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
