% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_functions_v8.R
\name{VisualizeCntr}
\alias{VisualizeCntr}
\title{Visualize Centroids}
\usage{
VisualizeCntr(
  centroids,
  width_px,
  height_px,
  pnt.cex = 1.2,
  txt.cex = 0.9,
  offset = 0.18,
  col = "red2"
)
}
\arguments{
\item{centroids}{centroid data.frame}

\item{width_px}{width of the image in pixels}

\item{height_px}{height of the image in pixels}

\item{pnt.cex}{cex of the point (circle) drawn around each cell}

\item{txt.cex}{cex of the text used to annotate the image}

\item{offset}{offset for the text annotations}

\item{col}{color of the points, e.g. "red2"}
}
\value{
None
}
\description{
Annotates centroids over an image
}
\examples{
x1 <- data.frame(
    row = c(50, 80, 20, 65, 99),
    col = c(15, 25, 50, 65, 86))
plot(2, 2, xlim = c(0,1), ylim = c(0,1), xlab = "", ylab = "", las = 2)
cellmigRation:::VisualizeCntr(x1, width_px = 100, height_px = 100)


}
\references{
\url{https://www.data-pulse.com/dev_site/cellmigration/}
\url{https://www.mathworks.com/matlabcentral/fileexchange/60349-fasttracks}
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
\keyword{internal}
