% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_functions_v8.R
\name{FilterTrackedCells}
\alias{FilterTrackedCells}
\title{Filter an Aggregated Table of Cell Tracks}
\usage{
FilterTrackedCells(x, id_list, meta_id_field)
}
\arguments{
\item{x}{data.frame, is an aggregated Table of Cell Tracks.
Must include the following columns:
"new.ID", "frame.ID", "X", "Y", "cell.ID", "tiff_name",
"experiment", "condition", "replicate"}

\item{id_list}{character vector, indicates the IDs (such as
tiff_filenames) to be retained in the
output data.frame}

\item{meta_id_field}{string, can take one of the following values,
c("tiff_file", "experiment", "condition", "replicate"). Indicates
the meta-data column used as unique ID for the image/experiment.
Can be abbreviated. Defaults to "tiff_file".}
}
\value{
data.frame, a filtered aggregated Table of Cell Tracks
}
\description{
Filter an Aggregated Table (data.frame) of cell tracks
(from multiple images/experiments) and
retain cell tracks from images/experiments of interest
}
\examples{
A <- data.frame(new.ID = seq(1,10,by=1), frame.ID = seq(10,1,by=(-1)),
                X = sample(seq(1,100,by=1), size = 10),
                Y = sample(seq(1,100,by=1), size = 10),
                cell.ID = c(rep(1, 5), rep(2, 5)),
                tiff_file= c(rep("ii", 3), rep("jj", 5), rep('kk', 2)))
FilterTrackedCells(A, id_list = c("jj", "kk"), "tiff_file")

}
\references{
\url{https://www.data-pulse.com/dev_site/cellmigration/}
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
