% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getGene-methods.R
\name{getGene,CellBaseR-method}
\alias{getGene,CellBaseR-method}
\alias{getGene}
\title{getGene}
\usage{
\S4method{getGene}{CellBaseR}(object, ids, resource, param = NULL)
}
\arguments{
\item{object}{an object of class CellBaseR}

\item{ids}{a character vector of gene ids to be queried}

\item{resource}{a character vector to specify the resource to be queried}

\item{param}{an object of class CellBaseParam specifying additional param
for the CellBaseR}
}
\value{
a dataframe with the results of the query
}
\description{
A method to query gene data from Cellbase web services.
}
\details{
This method retrieves various gene annotations including transcripts
and exons data as well as gene expression and clinical data
}
\examples{
   cb <- CellBaseR()
   res <- getGene(object=cb, ids=c("TP73","TET1"), resource="info")
}
\seealso{
\url{https://github.com/opencb/cellbase/wiki} 
and the RESTful API documentation 
\url{http://bioinfo.hpc.cam.ac.uk/cellbase/webservices/}
}
