% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/commons.R
\name{getCellBaseResourceHelp}
\alias{getCellBaseResourceHelp}
\title{getCellBaseResourceHelp}
\usage{
getCellBaseResourceHelp(object, subcategory)
}
\arguments{
\item{object}{a cellBase class object}

\item{subcategory}{a character the subcategory to be queried}
}
\value{
character vector of the available resources to that particular 
subcategory
}
\description{
A function to get help about available cellbase resources
}
\details{
This function retrieves available resources for each generic method
like getGene, getRegion, getprotein, etc. It help the user see all possible 
resources to use with the getGeneric methods
}
\examples{
cb <- CellBaseR()
# Get help about what resources are available to the getGene method
getCellBaseResourceHelp(cb, subcategory="gene")
# Get help about what resources are available to the getRegion method
getCellBaseResourceHelp(cb, subcategory="region")
# Get help about what resources are available to the getXref method
getCellBaseResourceHelp(cb, subcategory="id")
}
