% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterProbability.R
\name{clusterProbability}
\alias{clusterProbability}
\alias{clusterProbability,SingleCellExperiment-method}
\title{Get the conditional probabilities of cell in subpopulations from celda
 model}
\usage{
clusterProbability(
  sce,
  useAssay = "counts",
  altExpName = "featureSubset",
  log = FALSE
)

\S4method{clusterProbability}{SingleCellExperiment}(
  sce,
  useAssay = "counts",
  altExpName = "featureSubset",
  log = FALSE
)
}
\arguments{
\item{sce}{A \linkS4class{SingleCellExperiment} object returned by
\link{celda_C}, \link{celda_G}, or \link{celda_CG}, with the matrix
located in the \code{useAssay} assay slot.
Rows represent features and columns represent cells.}

\item{useAssay}{A string specifying which \link{assay}
slot to use. Default "counts".}

\item{altExpName}{The name for the \link{altExp} slot
to use. Default "featureSubset".}

\item{log}{Logical. If \code{FALSE}, then the normalized conditional
probabilities will be returned. If \code{TRUE}, then the unnormalized log
probabilities will be returned. Default \code{FALSE}.}
}
\value{
A list containging a matrix for the conditional cell subpopulation
 cluster and/or feature module probabilities.
}
\description{
Calculate the conditional probability of each cell belonging to
 each subpopulation given all other cell cluster assignments and/or
 each feature belonging to each module given all other feature cluster
 assignments in a celda model.
}
\examples{
data(sceCeldaCG)
clusterProb <- clusterProbability(sceCeldaCG, log = TRUE)
data(sceCeldaC)
clusterProb <- clusterProbability(sceCeldaC)
}
\seealso{
`celda_C()` for clustering cells
}
