% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loading_helper_functions.r
\name{convert_se_gene_ids}
\alias{convert_se_gene_ids}
\title{convert_se_gene_ids}
\usage{
convert_se_gene_ids(dataset_se, new_id, eval_col, find_max = TRUE)
}
\arguments{
\item{dataset_se}{Summarised experiment object containing count data. Also
requires 'ID' and 'group' to be set within the cell information
(see \code{colData()})}

\item{new_id}{A column within the feature information (view 
\code{colData(dataset_se)})) of the \bold{dataset_se}, which will become
the new ID column. Non-uniqueness of this column is handled gracefully! 
Any \emph{NAs} will be dropped.}

\item{eval_col}{Which column to use to break ties of duplicate 
\bold{new_id}. Must be a column within the feature information (view 
\code{colData(dataset_se)})) of the \bold{dataset_se}. Total reads per gene
feature is a good choice.}

\item{find_max}{If false, this will choose the minimal \bold{eval_col} 
instead of max. Default = TRUE}
}
\value{
A modified dataset_se - ID will now be \bold{new_id}, and unique. 
It will have fewer genes if old ID to new ID was not a 1:1 mapping. 
The selected genes will be according to the eval col max (or min). 
\emph{should} pick the alphabetical first on ties, but could change.
}
\description{
Change the gene IDs in in the supplied datatset_se object to some other id 
already present in the gene info (as seen with \code{rowData()})
}
\examples{

# The demo dataset doesn't have other names, so make some up 
# (don't do this)
dataset_se <- demo_ref_se
rowData(dataset_se)$dummyname <- toupper(rowData(dataset_se)$ID)

# If not already present, define a column to evaluate, 
# typically total reads/gene.
rowData(dataset_se)$total_count <- rowSums(assay(dataset_se))

dataset_se <- convert_se_gene_ids(dataset_se, new_id='dummyname', eval_col='total_count') 

}
\seealso{
\href{https://bioconductor.org/packages/release/bioc/html/SummarizedExperiment.html}{SummarizedExperiment} 
For general doco on the SummarizedExperiment objects.

\code{\link{load_se_from_files}} For reading data from flat 
files (not 10X cellRanger output)
}
