% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_iteration.R
\name{find_iteration}
\alias{find_iteration}
\title{Finds the iteration which provides maximum affected node number}
\usage{
find_iteration(df, limit = 0.1, plot = FALSE)
}
\arguments{
\item{df}{A tbl graph that includes the miRNA and competing targets
triggered and simulated for number of cycles.}

\item{limit}{The minimum amount of change of any node.}

\item{plot}{If TRUE, returns a plot.}
}
\value{
It gives an iteration number to use in simulate() function.
}
\description{
searches the iteration that provides maximum affected node number.
 The user defines a symbolic iteration with .iter. The function
 calculates the number of affected nodes for each iteration and
 then selects the iteration that has maximum affected nodes' number.
}
\examples{

data('midsamp')

midsamp \%>\%
  priming_graph(Gene_expression, miRNA_expression) \%>\%
  update_how('Gene2',2) \%>\%
  simulate(10) \%>\%
  find_iteration(limit=0)

}
