% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{visualize_clusters}
\alias{visualize_clusters}
\title{Visualize clusters}
\usage{
visualize_clusters(object, rank, verbose = FALSE, cex = 1,
  cex.names = 0.7, ...)
}
\arguments{
\item{object}{\code{scNMF} object.}

\item{rank}{Rank value to extract from \code{object}.}

\item{verbose}{Print tSNE messages.}

\item{cex}{Symbol size in tSNE plot}

\item{cex.names}{Font size of labels in count barplot.}

\item{...}{Other parameters to send to \code{Rtsne}.}
}
\value{
\code{NULL}
}
\description{
Use tSNE to generate two-dimensional map of coefficient matrix.
}
\details{
It retrieves a coefficient matrix \code{H} 
from an object and use its elements
to assign each cell into clusters. 
t-Distributed Stochastic Neighbor Embedding (t-SNE; 
\url{https://lvdmaaten.github.io/tsne/}) is used to visualize the 
clustering
in 2D. Also plotted is the distribution of cell counts for all clusters.
}
\examples{
set.seed(1)
x <- simulate_data(nfeatures=10,nsamples=c(20,20,60,40,30))
rownames(x) <- seq_len(10)
colnames(x) <- seq_len(170)
s <- scNMFSet(count=x,rowData=seq_len(10),colData=seq_len(170))
s <- vb_factorize(s,ranks=seq(2,5))
visualize_clusters(s,rank=5)
}
